<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwtrait="urn:WebWorks-Engine-FormatTraitInfo-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwadapter="urn:WebWorks-XSLT-Extension-Adapter"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwbehaviors wwsplits wwproject wwtrait wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwunits wwprojext wwadapter wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterPostScriptType" />
 <xsl:param name="ParameterDefaultFormat" />
 <xsl:param name="ParameterAllowThumbnails" />
 <xsl:param name="ParameterThumbnailType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwfiles-files-by-documentid" match="wwfiles:File" use="@documentID" />
 <xsl:key name="wwsplits-frames-by-documentid" match="wwsplits:Frame" use="@documentID" />
 <xsl:key name="wwdoc-frames-by-id" match="wwdoc:Frame" use="@id" />
 <xsl:key name="wwbehaviors-frames-by-id" match="wwbehaviors:Frame" use="@id" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarIgnore1Start" select="wwprogress:Start(count($VarProjectGroups))" />
   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <!-- Splits -->
    <!--        -->
    <xsl:variable name="VarIgnore2Start" select="wwprogress:Start(1)" />
    <xsl:for-each select="$GlobalInput[1]">
     <xsl:variable name="VarSplitsFiles" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))" />
     <xsl:for-each select="$VarSplitsFiles[1]">
      <xsl:variable name="VarSplitsFile" select="." />

      <!-- Load splits -->
      <!--             -->
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarSplitsFile/@path)" />
      <xsl:if test="count($VarSplits//wwsplits:Frame) &gt; 0">
       <!-- Documents -->
       <!--           -->
       <xsl:variable name="VarProjectDocuments" select="$VarProjectGroup//wwproject:Document" />
       <xsl:variable name="VarIgnore3Start" select="wwprogress:Start(count($VarProjectDocuments))" />
       <xsl:for-each select="$VarProjectDocuments">
        <xsl:variable name="VarProjectDocument" select="." />

        <xsl:variable name="VarIgnore4Start" select="wwprogress:Start(1)" />

        <!-- Aborted? -->
        <!--          -->
        <xsl:if test="not(wwprogress:Abort())">
         <!-- Document Frames -->
         <!--                 -->
         <xsl:for-each select="$VarSplits[1]">
          <xsl:variable name="VarSplitFrames" select="key('wwsplits-frames-by-documentid', $VarProjectDocument/@DocumentID)" />
          <xsl:if test="count($VarSplitFrames) &gt; 0">
           <!-- Load document -->
           <!--               -->
           <xsl:for-each select="$GlobalInput[1]">
            <xsl:variable name="VarDocumentFiles" select="key('wwfiles-files-by-documentid', $VarProjectDocument/@DocumentID)[@type = $ParameterDependsType]" />
            <xsl:variable name="VarBehaviorsFiles" select="key('wwfiles-files-by-documentid', $VarProjectDocument/@DocumentID)[@type = $ParameterBehaviorsType]" />

            <!-- Load document -->
            <!--               -->
            <xsl:for-each select="$VarDocumentFiles[1]">
             <xsl:variable name="VarDocumentFile" select="." />
             <xsl:variable name="VarDocument" select="wwexsldoc:LoadXMLWithoutResolver($VarDocumentFile/@path)" />

             <!-- Load behaviors -->
             <!--                -->
             <xsl:for-each select="$VarBehaviorsFiles[1]">
              <xsl:variable name="VarBehaviorsFile" select="." />
              <xsl:variable name="VarBehaviors" select="wwexsldoc:LoadXMLWithoutResolver($VarBehaviorsFile/@path)" />
   
              <!-- Process document frames -->
              <!--                         -->
              <xsl:variable name="VarIgnore5Start" select="wwprogress:Start(count($VarSplitFrames))" />
              <xsl:for-each select="$VarSplitFrames">
               <xsl:variable name="VarSplitFrame" select="." />

               <xsl:variable name="VarIgnore6Start" select="wwprogress:Start(1)" />

               <!-- Aborted? -->
               <!--          -->
               <xsl:if test="not(wwprogress:Abort())">
                <!-- Graphic Rule -->
                <!--              -->
                <xsl:variable name="VarContextRule" select="wwprojext:GetContextRule('Graphic', $VarSplitFrame/@stylename, $VarSplitFrame/@documentID, $VarSplitFrame/@id)" />
                <xsl:variable name="VarGenerateOutputOption" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
                <xsl:variable name="VarGenerateOutput" select="(string-length($VarGenerateOutputOption) = 0) or ($VarGenerateOutputOption != 'false')" />
                <xsl:if test="$VarGenerateOutput">
                 <!-- Locate document frame -->
                 <!--                       -->
                 <xsl:for-each select="$VarDocument[1]">
                  <xsl:variable name="VarDocumentFrame" select="key('wwdoc-frames-by-id', $VarSplitFrame/@id)[1]" />

                  <!-- Locate behaviors frame -->
                  <!--                        -->
                  <xsl:for-each select="$VarBehaviors[1]">
                   <xsl:variable name="VarBehaviorsFrame" select="key('wwbehaviors-frames-by-id', $VarSplitFrame/@id)[1]" />

                   <!-- Full size -->
                   <!--           -->
                   <xsl:call-template name="FullSize">
                    <xsl:with-param name="ParamDocumentFile" select="$VarDocumentFile" />
                    <xsl:with-param name="ParamBehaviorsFile" select="$VarBehaviorsFile" />
                    <xsl:with-param name="ParamSplitsFile" select="$VarSplitsFile" />
                    <xsl:with-param name="ParamDocumentFrame" select="$VarDocumentFrame" />
                    <xsl:with-param name="ParamBehaviorsFrame" select="$VarBehaviorsFrame" />
                    <xsl:with-param name="ParamSplitFrame" select="$VarSplitFrame" />
                    <xsl:with-param name="ParamContextRule" select="$VarContextRule" />
                   </xsl:call-template>

                   <!-- Thumbnail -->
                   <!--           -->
                   <xsl:if test="$ParameterAllowThumbnails = 'true'">
                    <xsl:call-template name="Thumbnail">
                     <xsl:with-param name="ParamDocumentFrame" select="$VarDocumentFrame" />
                     <xsl:with-param name="ParamBehaviorsFrame" select="$VarBehaviorsFrame" />
                     <xsl:with-param name="ParamSplitFrame" select="$VarSplitFrame" />
                     <xsl:with-param name="ParamContextRule" select="$VarContextRule" />
                    </xsl:call-template>
                   </xsl:if>
                  </xsl:for-each>
                 </xsl:for-each>
                </xsl:if>
               </xsl:if>

               <xsl:variable name="VarIgnore6End" select="wwprogress:End()" />
              </xsl:for-each>
             </xsl:for-each>
             <xsl:variable name="VarIgnore5End" select="wwprogress:End()" />
            </xsl:for-each>
           </xsl:for-each>
          </xsl:if>
         </xsl:for-each>
        </xsl:if>

        <xsl:variable name="VarIgnore4End" select="wwprogress:End()" />

       </xsl:for-each>
       <xsl:variable name="VarIgnore3End" select="wwprogress:End()" />

      </xsl:if>

     </xsl:for-each>

    </xsl:for-each>
    <xsl:variable name="VarIgnore2End" select="wwprogress:End()" />

   </xsl:for-each>
   <xsl:variable name="VarIgnore1End" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="MaxSizeOption">
  <xsl:param name="ParamMaxSizeOptionValue" />

  <xsl:choose>
   <xsl:when test="$ParamMaxSizeOptionValue = 'none'">
    <xsl:value-of select="0" />
   </xsl:when>

   <xsl:when test="(string-length($ParamMaxSizeOptionValue) &gt; 0) and (number($ParamMaxSizeOptionValue) &gt; 0)">
    <xsl:value-of select="number($ParamMaxSizeOptionValue)" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:value-of select="0" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="FullSize">
  <xsl:param name="ParamDocumentFile" />
  <xsl:param name="ParamBehaviorsFile" />
  <xsl:param name="ParamSplitsFile" />
  <xsl:param name="ParamDocumentFrame" />
  <xsl:param name="ParamBehaviorsFrame" />
  <xsl:param name="ParamSplitFrame" />
  <xsl:param name="ParamContextRule" />

  <!-- Skip by reference graphics -->
  <!--                            -->
  <xsl:if test="(not($ParamSplitFrame/@byref)) or ($ParamSplitFrame/@byref != 'true')">
   <!-- Generate PostScript -->
   <!--                     -->
   <xsl:variable name="VarPostScriptPath" select="wwfilesystem:Combine(wwprojext:GetDocumentDataDirectoryPath($ParamSplitFrame/@documentID), concat(translate($ParameterType, ':', '_'), '_', $ParamSplitFrame/@id, '.ps'))" />
   <xsl:variable name="VarPostScriptUpToDate" select="wwfilesext:UpToDate($VarPostScriptPath, '', $ParamSplitFrame/@groupID, $ParamSplitFrame/@documentID, $GlobalActionChecksum)" />
   <xsl:if test="not($VarPostScriptUpToDate)">
    <xsl:variable name="VarIgnoreResult" select="wwadapter:GeneratePostScriptForImage($ParamDocumentFrame, $VarPostScriptPath)" />
   </xsl:if>

   <!-- Dependency info -->
   <!--                 -->
   <xsl:variable name="VarPostScriptChecksum" select="wwfilesystem:GetChecksum($VarPostScriptPath)" />
   <wwfiles:File path="{$VarPostScriptPath}" type="$ParameterPostScriptType" checksum="{$VarPostScriptChecksum}" projectchecksum="" groupID="{$ParamSplitFrame/@groupID}" documentID="{$ParamSplitFrame/@documentID}" actionchecksum="{$GlobalActionChecksum}">
    <wwfiles:Depends path="{$ParamDocumentFile/@path}" checksum="{$ParamDocumentFile/@checksum}" groupID="{$ParamDocumentFile/@groupID}" documentID="{$ParamDocumentFile/@documentID}" />
   </wwfiles:File>

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <!-- Get image-scale marker -->
    <!--                        -->
    <xsl:variable name="VarImageScale">
     <xsl:variable name="VarImageScaleBehaviorMarkers" select="$ParamBehaviorsFrame//wwbehaviors:Marker[@behavior = 'image-scale']" />
     <xsl:if test="count($VarImageScaleBehaviorMarkers) &gt; 0">
      <xsl:variable name="VarImageScaleMarkerValue">
       <!-- Use last one defined -->
       <!--                      -->
       <xsl:for-each select="$VarImageScaleBehaviorMarkers[count($VarImageScaleBehaviorMarkers)]">
        <xsl:variable name="VarImageScaleBehaviorMarker" select="." />

        <xsl:for-each select="$VarImageScaleBehaviorMarker/wwdoc:Marker/wwdoc:TextRun/wwdoc:Text">
         <xsl:value-of select="@value" />
        </xsl:for-each>
       </xsl:for-each>
      </xsl:variable>

      <xsl:if test="(string-length($VarImageScaleMarkerValue) &gt; 0) and (number($VarImageScaleMarkerValue) &gt; 0)">
       <xsl:value-of select="number($VarImageScaleMarkerValue)" />
      </xsl:if>
     </xsl:if>
    </xsl:variable>

    <!-- Get graphic options -->
    <!--                     -->
    <xsl:variable name="VarMaxWidthOption">
     <xsl:call-template name="MaxSizeOption">
      <xsl:with-param name="ParamMaxSizeOptionValue" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'max-width']/@Value" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarMaxHeightOption">
     <xsl:call-template name="MaxSizeOption">
      <xsl:with-param name="ParamMaxSizeOptionValue" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'max-height']/@Value" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarScaleOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'scale']/@Value" />

    <!-- Generate image -->
    <!--                -->
    <xsl:variable name="VarImageUpToDate" select="wwfilesext:UpToDate($ParamSplitFrame/@path, concat($GlobalProject/wwproject:Project/@ChangeID, ':', $VarImageScale, ':', $VarScaleOption, ':', $VarMaxWidthOption, ':', $VarMaxHeightOption), $ParamSplitFrame/@groupID, $ParamSplitFrame/@documentID, $GlobalActionChecksum)" />
    <xsl:if test="not($VarPostScriptUpToDate) or not($VarImageUpToDate)">
     <!-- Rasterize -->
     <!--           -->
     <xsl:variable name="VarDocumentFrameWidth" select="wwunits:NumericPrefix($ParamDocumentFrame/wwdoc:Attribute[@name = 'width']/@value)" />
     <xsl:variable name="VarDocumentFrameHeight" select="wwunits:NumericPrefix($ParamDocumentFrame/wwdoc:Attribute[@name = 'height']/@value)" />
     <xsl:if test="($VarDocumentFrameWidth &gt; 0) and ($VarDocumentFrameHeight &gt; 0)">
      <!-- Render DPI -->
      <!--            -->
      <xsl:variable name="VarRenderDPI">
       <xsl:variable name="VarRenderDPIOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'render-dpi']/@Value" />
       <xsl:choose>
        <xsl:when test="string-length($VarRenderDPIOption) &gt; 0">
         <xsl:value-of select="$VarRenderDPIOption" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="96" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- Width/Height -->
      <!--              -->
      <xsl:variable name="VarWidth" select="wwunits:Convert($VarDocumentFrameWidth, 'points', 'inches') * $VarRenderDPI" />
      <xsl:variable name="VarHeight" select="wwunits:Convert($VarDocumentFrameHeight, 'points', 'inches') * $VarRenderDPI" />

      <!-- Format -->
      <!--        -->
      <xsl:variable name="VarFormat">
       <xsl:variable name="VarFormatOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'format']/@Value" />
       <xsl:choose>
        <xsl:when test="string-length($VarFormatOption) &gt; 0">
         <xsl:value-of select="$VarFormatOption" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="$ParameterDefaultFormat" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- Color Depth -->
      <!--             -->
      <xsl:variable name="VarColorDepth">
       <xsl:variable name="VarColorDepthOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'color-depth']/@Value" />
       <xsl:choose>
        <xsl:when test="number($VarColorDepthOption) &gt; 0">
         <xsl:value-of select="$VarColorDepthOption" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="256" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- Grayscale -->
      <!--           -->
      <xsl:variable name="VarGrayscaleOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'grayscale']/@Value" />
      <xsl:variable name="VarGrayscale" select="$VarGrayscaleOption = 'true'" />

      <!-- Transparent -->
      <!--             -->
      <xsl:variable name="VarTransparentOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'transparent']/@Value" />
      <xsl:variable name="VarTransparent" select="$VarTransparentOption = 'true'" />

      <!-- Interlaced (for GIFs) -->
      <!--                       -->
      <xsl:variable name="VarInterlacedOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'interlaced']/@Value" />
      <xsl:variable name="VarInterlaced" select="$VarInterlacedOption = 'true'" />

      <!-- Quality (for JPEGs) -->
      <!--                     -->
      <xsl:variable name="VarQuality">
       <xsl:variable name="VarQualityOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'quality']/@Value" />
       <xsl:choose>
        <xsl:when test="number($VarQualityOption) &gt; 0">
         <xsl:value-of select="$VarQualityOption" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="75" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- Determine scaling ratio -->
      <!--                         -->
      <xsl:variable name="VarUpScalingRatio">
       <xsl:choose>
        <!-- Use image-scale markers if defined -->
        <!--                                    -->
        <xsl:when test="string-length($VarImageScale) &gt; 0">
         <xsl:value-of select="$VarImageScale div 100.0" />
        </xsl:when>

        <!-- Scale -->
        <!--       -->
        <xsl:when test="(string-length($VarScaleOption) &gt; 0) and ($VarScaleOption != 'none') and (number($VarScaleOption) &gt; 0)">
         <xsl:value-of select="$VarScaleOption div 100.0" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="0.0" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- Record upscaling parameters -->
      <!--                             -->
      <xsl:variable name="VarScaledRenderDPI">
       <xsl:choose>
        <xsl:when test="$VarUpScalingRatio &gt; 1.0">
         <xsl:value-of select="round($VarRenderDPI * $VarUpScalingRatio)" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="$VarRenderDPI" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>
      <xsl:variable name="VarScaledWidth">
       <xsl:choose>
        <xsl:when test="$VarUpScalingRatio &gt; 1.0">
         <xsl:value-of select="ceiling($VarWidth * $VarUpScalingRatio)" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="ceiling($VarWidth)" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>
      <xsl:variable name="VarScaledHeight">
       <xsl:choose>
        <xsl:when test="$VarUpScalingRatio &gt; 1.0">
         <xsl:value-of select="ceiling($VarHeight * $VarUpScalingRatio)" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="ceiling($VarHeight)" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:variable>

      <!-- Rasterize PostScript -->
      <!--                      -->
      <xsl:variable name="VarAdapterName" select="$ParamDocumentFrame/wwdoc:Facets/wwdoc:Facet[@type = 'document']/wwdoc:Attribute[@name = 'adapter']/@value" />
      <xsl:variable name="VarImageInfo" select="wwimaging:RasterizePostScript($VarPostScriptPath, $VarScaledRenderDPI, $VarScaledRenderDPI, $VarScaledWidth, $VarScaledHeight, $VarFormat, $VarColorDepth, $VarGrayscale, $VarTransparent, $VarInterlaced, $VarQuality, $ParamSplitFrame/@path)" />
      <xsl:if test="(number($VarImageInfo/@width) &gt; 0) and (number($VarImageInfo/@height) &gt; 0)">
       <!-- Determine downscaling ratio -->
       <!--                             -->
       <xsl:variable name="VarDownScalingRatio">
        <xsl:choose>
         <!-- Use image-scale markers if defined -->
         <!--                                    -->
         <xsl:when test="string-length($VarImageScale) &gt; 0">
          <xsl:value-of select="$VarImageScale div 100.0" />
         </xsl:when>

         <!-- Use graphic options -->
         <!--                     -->
         <xsl:otherwise>
          <xsl:choose>
           <!-- Max Width/Height -->
           <!--                  -->
           <xsl:when test="($VarMaxWidthOption &gt; 0) or ($VarMaxHeightOption &gt; 0)">
            <!-- Determine scaling ratio -->
            <!--                         -->
            <xsl:variable name="VarWidthRatio" select="$VarMaxWidthOption div $VarImageInfo/@width" />
            <xsl:variable name="VarHeightRatio" select="$VarMaxHeightOption div $VarImageInfo/@height" />
            <xsl:choose>
             <xsl:when test="(($VarWidthRatio &gt; 0) and ($VarWidthRatio &lt; $VarHeightRatio)) or ($VarHeightRatio = 0)">
              <xsl:value-of select="$VarWidthRatio" />
             </xsl:when>

             <xsl:otherwise>
              <xsl:value-of select="$VarHeightRatio" />
             </xsl:otherwise>
            </xsl:choose>
           </xsl:when>

           <!-- Scale -->
           <!--       -->
           <xsl:when test="(string-length($VarScaleOption) &gt; 0) and ($VarScaleOption != 'none') and (number($VarScaleOption) &gt; 0)">
            <xsl:value-of select="$VarScaleOption div 100.0" />
           </xsl:when>

           <xsl:otherwise>
            <xsl:value-of select="0.0" />
           </xsl:otherwise>
          </xsl:choose>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <!-- Need to resize? -->
       <!--                 -->
       <xsl:if test="($VarDownScalingRatio &gt; 0.0) and ($VarDownScalingRatio &lt; 1.0)">
        <xsl:variable name="VarResizeWidth" select="ceiling($VarImageInfo/@width * $VarDownScalingRatio)" />
        <xsl:variable name="VarResizeHeight" select="ceiling($VarImageInfo/@height * $VarDownScalingRatio)" />

        <xsl:variable name="VarIgnoreResize">
         <xsl:value-of select="wwimaging:Transform($ParamSplitFrame/@path, $VarImageInfo/@format, $VarResizeWidth, $VarResizeHeight, $ParamSplitFrame/@path)" />
        </xsl:variable>
       </xsl:if>
      </xsl:if>
     </xsl:if>
    </xsl:if>

    <!-- Dependency info -->
    <!--                 -->
    <wwfiles:File path="{$ParamSplitFrame/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($ParamSplitFrame/@path)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', $VarImageScale, ':', $VarScaleOption, ':', $VarMaxWidthOption, ':', $VarMaxHeightOption)}" groupID="{$ParamSplitFrame/@groupID}" documentID="{$ParamSplitFrame/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$VarPostScriptPath}" checksum="{$VarPostScriptChecksum}" groupID="{$ParamSplitFrame/@groupID}" documentID="{$ParamSplitFrame/@documentID}" />
     <wwfiles:Depends path="{$ParamBehaviorsFile/@path}" checksum="{$ParamBehaviorsFile/@checksum}" groupID="{$ParamBehaviorsFile/@groupID}" documentID="{$ParamBehaviorsFile/@documentID}" />
    </wwfiles:File>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Thumbnail">
  <xsl:param name="ParamDocumentFrame" />
  <xsl:param name="ParamBehaviorsFrame" />
  <xsl:param name="ParamSplitFrame" />
  <xsl:param name="ParamContextRule" />

  <xsl:variable name="VarThumbnailWidthOption">
   <xsl:call-template name="MaxSizeOption">
    <xsl:with-param name="ParamMaxSizeOptionValue" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'thumbnail-width']/@Value" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarThumbnailHeightOption">
   <xsl:call-template name="MaxSizeOption">
    <xsl:with-param name="ParamMaxSizeOptionValue" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'thumbnail-height']/@Value" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:if test="($VarThumbnailWidthOption &gt; 0) or ($VarThumbnailHeightOption &gt; 0)">
   <!-- Determine source image path -->
   <!--                             -->
   <xsl:variable name="VarThumbnailSourcePath">
    <xsl:choose>
     <!-- Thumbnails may not have been copied yet -->
     <!--                                         -->
     <xsl:when test="$ParamSplitFrame/@byref != 'true'">
      <xsl:value-of select="$ParamSplitFrame/@source" />
     </xsl:when>

     <!-- Image exists because it was just generated -->
     <!--                                            -->
     <xsl:otherwise>
      <xsl:value-of select="$ParamSplitFrame/@path" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Get thumbnail source image info -->
   <!--                                 -->
   <xsl:variable name="VarThumbnailSourceImageInfo" select="wwimaging:GetInfo($VarThumbnailSourcePath)" />

   <!-- Determine scaling ratio -->
   <!--                         -->
   <xsl:variable name="VarScalingRatio">
    <xsl:variable name="VarWidthRatio" select="$VarThumbnailWidthOption div $VarThumbnailSourceImageInfo/@width" />
    <xsl:variable name="VarHeightRatio" select="$VarThumbnailHeightOption div $VarThumbnailSourceImageInfo/@height" />
    <xsl:choose>
     <xsl:when test="(($VarWidthRatio &gt; 0) and ($VarWidthRatio &lt; $VarHeightRatio)) or ($VarHeightRatio = 0)">
      <xsl:value-of select="$VarWidthRatio" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="$VarHeightRatio" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Need thumbnail? -->
   <!--                 -->
   <xsl:if test="($VarScalingRatio &gt; 0.0) and ($VarScalingRatio &lt; 1.0)">
    <!-- Thumbnail up-to-date? -->
    <!--                       -->
    <xsl:variable name="VarThumbnailPath" select="$ParamSplitFrame/wwsplits:Thumbnail/@path" />
    <xsl:variable name="VarThumbnailUpToDate" select="wwfilesext:UpToDate($VarThumbnailPath, $GlobalProject/wwproject:Project/@ChangeID, $ParamSplitFrame/@groupID, $ParamSplitFrame/@documentID, $GlobalActionChecksum)" />
    <xsl:if test="not($VarThumbnailUpToDate)">
     <xsl:variable name="VarResizeWidth" select="ceiling($VarThumbnailSourceImageInfo/@width * $VarScalingRatio)" />
     <xsl:variable name="VarResizeHeight" select="ceiling($VarThumbnailSourceImageInfo/@height * $VarScalingRatio)" />

     <xsl:variable name="VarIgnoreResize">
      <xsl:value-of select="wwimaging:Transform($VarThumbnailSourcePath, $VarThumbnailSourceImageInfo/@format, $VarResizeWidth, $VarResizeHeight, $VarThumbnailPath)" />
     </xsl:variable>
    </xsl:if>

    <!-- Track thumbnail file -->
    <!--                      -->
    <wwfiles:File path="{$VarThumbnailPath}" type="{$ParameterThumbnailType}" checksum="{wwfilesystem:GetChecksum($VarThumbnailPath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$ParamSplitFrame/@groupID}" documentID="{$ParamSplitFrame/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="" use="" deploy="{$ParameterDeploy}">
     <wwfiles:Depends path="{$VarThumbnailSourcePath}" checksum="{wwfilesystem:GetChecksum($VarThumbnailSourcePath)}" groupID="{$ParamSplitFrame/@groupID}" documentID="{$ParamSplitFrame/@documentID}" />
    </wwfiles:File>
   </xsl:if>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
